Program NDDECLI;
{$R NDDECLI}
Uses
  WinTypes, WinProcs, Objects, OWindows, ODialogs, Win31, DDEML, NDDEAPI, Winnet,
  Strings, BWCC, oStdDlgs;

Const
  Service_Name : PChar = 'nddesvr';
  Share_Name : PChar = 'NDDESVR$';
  App_Name : PChar = 'NDDESVR';
  Topic_Name : PChar = 'BORLAND';
  Item_Name : PChar = 'Products';

  AppTitle : PChar = 'Network DDE Client';

  TDMLClWnd_Menu = 1;

  CM_U_Connect = $100;
  CM_U_Request = $101;
  CM_U_Poke = $102;
  CM_U_Advise = $103;

  CM_U_HelpAbout = $200;

Type
{ TNDDEClWnd }
  PNDDEClWnd = ^TNDDEClWnd;
  TNDDEClWnd = object(TWindow)
    szData : Array[0..128] of Char;
    idInst : LongInt;
    Conv :  hConv;
    tfLoop : Boolean;
    hszShare, hszService, hszTopic, hszItem : hSz;
    CallBack : TCallBack;

    Constructor Init(AParent : PWindowsObject; ATitle : PChar);
    Destructor Done; virtual;
    Procedure SetUpWindow; virtual;
    Procedure Paint(PaintDC : hDC; var PaintInfo : TPaintStruct); virtual;
    Procedure WMInitMenu(var Msg : TMessage); virtual WM_First + WM_InitMenu;
    Procedure CMExit(var Msg : TMessage); virtual CM_First + CM_Exit;
    Procedure CMUConnect(var Msg : TMessage); virtual CM_First + CM_U_Connect;
    Procedure CMURequest(var Msg : TMessage); virtual CM_First + CM_U_Request;
    Procedure CMUPoke(var Msg : TMessage); virtual CM_First + CM_U_Poke;
    Procedure CMUAdvise(var Msg : TMessage); virtual CM_First + CM_U_Advise;
    Procedure CMUHelpAbout(var Msg : TMessage); virtual CM_First + CM_U_HelpAbout;
    Procedure ReceivedData(hData : hDDEData);
  Private
    LocalName,
    ConnectName : Array[0..50] of Char;
  end;

Var
  ConvWindow : PNDDEClWnd;

Function CallBackProc(CallType, Fmt : Word; Conv : hConv; HSz1,HSz2 : HSz;
                      hData : HDDEData; Data1,Data2 : LongInt) : HDDEData; export;
var
  szTemp : Array[0..128] of char;
  iSize : Integer;
begin
  CallBackProc := 0;
  Case CallType of
    XTYP_ADVDATA : begin
      if ConvWindow^.Conv = Conv then
      begin
        ConvWindow^.ReceivedData(hData);
        CallBackProc := DDE_FACK;
      end;
    end;

    XTYP_XACT_COMPLETE : begin
      if ConvWindow^.Conv = Conv then
      begin
        ConvWindow^.ReceivedData(hData);
        CallBackProc := 1;
      end;
    end;
    XTYP_DISCONNECT : begin
      ConvWindow^.Conv := 0;
      ConvWindow^.tfLoop := FALSE;
      PostMessage(ConvWindow^.hWindow, WM_InitMenu, WORD(GetMenu(ConvWindow^.hWindow)), 0);
      CallBackProc := 1;
    end;

    XTYP_ERROR : begin
      MessageBox(ConvWindow^.hWindow, 'A Critical DDE error has occured.', AppTitle, MB_ICONINFORMATION);
    end;
  end;
end;

Constructor TNDDEClWnd.Init(AParent : PWindowsObject; ATitle : PChar);
var
  TempName : Array[0..50] of Char;

begin
  inherited Init(AParent, ATitle);
  With Attr do
  begin
    Style := ws_Overlapped  +
             ws_Caption     +
             ws_SysMenu     +
             ws_Minimizebox;
    X     := 150;
    Y     := 50;
    W     := 400;
    H     := 360;
    Menu:= LoadMenu(HInstance, PChar(TDMLClWnd_Menu));
  end;
  { Get our local Name }

  NDDEGetNodeName(TempName, Sizeof(TempName));
  { Will need // added if not already there }

  if (TempName[0] <> '\') OR (TempName[1] <> '\') then
    strcopy(LocalName, '\\')
  else
    strcopy(LocalName, '');
  strcat(LocalName, TempName);
end;

Destructor TNDDEClWnd.Done;
begin
  if Conv <> 0 then
  begin
    DDEDisConnect(Conv);
    Conv := 0;
  end;
  if idInst <> 0 then
  begin
    DDEFreeStringHandle(idInst, hszService);
    DDEFreeStringHandle(idInst, hszTopic);
    DDEFreeStringHandle(idInst, hszItem);
    DDEFreeStringHandle(idInst, hszShare);
    DDEUnInitialize(idInst);
    idInst := 0;
  end;
  if @CallBack<>NIL then
  begin
    FreeProcInstance(@CallBack);
    @CallBack := NIL;
  end;
  inherited Done;
end;

Procedure TNDDEClWnd.SetupWindow;
begin
  idInst := 0;
  Conv := 0;
  tfLoop := FALSE;
  StrCopy(szData, '');
  hszTopic := 0;
  hszItem := 0;
  hszShare := 0;
  @CallBack := MakeProcInstance(@CallBackProc, hInstance);
  if @CallBack<>NIL then
  begin
    if DDEInitialize(idInst, CallBack, APPCMD_ClientOnly + CBF_Skip_Registrations
                     + CBF_Skip_UnRegistrations, 0) = DMLERR_NO_ERROR then
    begin
      hszShare := DDECreateStringHandle(idInst, Share_Name, CP_WINANSI);
      hszTopic := DDECreateStringHandle(idInst, Topic_Name, CP_WINANSI);
      hszItem := DDECreateStringHandle(idInst, Item_Name, CP_WINANSI);
      if (hszShare = 0) OR (hszTopic = 0) OR (hszItem = 0) then
      begin
        MessageBox(hWindow, 'String creation failed.', AppTitle, MB_IconStop);
        PostQuitMessage(0);
      end;
    end
    else
    begin
      MessageBox(hWindow, 'Initialization failed.', AppTitle, MB_IconStop);
      PostQuitMessage(0);
    end;
  end
  else
  begin
    MessageBox(hWindow, 'Setup of CALLBACK failed', AppTitle, MB_IconStop);
    PostQuitMessage(0);
  end;
end;

Procedure TNDDEClWnd.Paint(PaintDC : hDC; var PaintInfo : TPaintStruct);
var
  rTemp : TRect;
begin
  GetClientRect(hWindow, rTemp);
  If szData[0] <> #0 then
    DrawText(PaintDC, szData, strlen(szData), rTemp, DT_SINGLELINE + DT_CENTER + DT_VCENTER);
end;

Procedure TNDDEClWnd.CMExit(var Msg : TMessage);
begin
  inherited CMExit(Msg);
end;

Procedure TNDDEclWnd.WMInitMenu(var Msg : TMessage);
var
  hmTemp : hMenu;
begin
  hmTemp := HMENU(msg.wParam);
  if Conv = 0 then
  begin
    EnableMenuItem(hmTemp, CM_U_Connect, MF_ENABLED);
    EnableMenuItem(hmTemp, CM_U_Request, MF_GRAYED);
    EnableMenuItem(hmTemp, CM_U_Poke, MF_GRAYED);
    EnableMenuItem(hmTemp, CM_U_Advise, MF_GRAYED);
  end
  else
  begin
    EnableMenuItem(hmTemp, CM_U_Connect, MF_GRAYED);
    EnableMenuItem(hmTemp, CM_U_Request, MF_ENABLED);
    EnableMenuItem(hmTemp, CM_U_Poke, MF_ENABLED);
    EnableMenuItem(hmTemp, CM_U_Advise, MF_ENABLED);
  end;

  if tfLoop = TRUE then
    CheckMenuItem(hmTemp, CM_U_ADVISE, MF_BYCOMMAND + MF_CHECKED)
  else
    CheckMenuItem(hmTemp, CM_U_ADVISE, MF_BYCOMMAND + MF_UNCHECKED);
  DrawMenuBar(hWindow);
end;

Procedure TNDDEClWnd.CMUConnect(var Msg : TMessage);
Const
  TempServ : PChar = '%s\%s';
  NDDEConnection : PChar = 'NDDE$';          { Signature for network DDE protocol }
var
  hNet : tHandle;
  TempArray : Array[0..1] of LongInt;
  szTemp : Array[0..100] of Char;
  Error : Word;

begin
  hNet := WNetGetCaps($FFFF); { Get the handle to the network driver }

  { Then get the address of the Browse Dialog }
  @WNetServerBrowseDialog := GetProcAddress(hNet, MakeIntResource(ORD_WNETSERVERBROWSEDIALOG));

  { Call It, then free it }
  WNetServerBrowseDialog(hWindow, LocalName, ConnectName, 50, 0);
  FreeProcInstance(@WNetServerBrowseDialog);


  { Set up connection service - format of '\\computername\NDDE$' }

  TempArray[0] := LONGINT(@ConnectName);
  TempArray[1] := LONGINT(NDDEConnection);
  wvsprintf(szTemp, TempServ, TempArray);
  hszService := DDECreateStringHandle(idInst, szTemp, CP_WINANSI);

  { Connection with service as above, and topic equal to the share name set by the server }
  Conv := DDEConnect(idInst, hszService, hszShare, NIL);
  DDEFreeStringHandle(idInst, hszService); { Don't need this any more }

  if Conv<>0 then
  begin
    { The DDEconnect will probably always succeed. We need to do a client transaction }
    { to see if the server is actually responding before we know that there is an }
    { active conversation. }

    DDEClientTransaction(NIL, 0, Conv, hszItem, CF_Text, XTYP_Request, 30000, NIL);
    Error := DDEGetLastError(idInst);
    If Error<>0 then
    begin
      MessageBox(hWindow, 'Can''t start the conversation', AppTitle, MB_ICONSTOP + MB_OK);
      Conv := 0;
    end
    else
      PostMessage(hWindow, WM_InitMenu, Word(GetMenu(hWindow)), 0);
  end;
end;

Procedure TNDDEClWnd.CMURequest(var Msg : TMessage);
var
  hData : hDDEData;
begin
  hData := DDEClientTransaction(NIL, 0, Conv, hszItem, CF_TEXT, XTYP_REQUEST, 0, NIL);
  if BOOL(hData) <> FALSE then
    ReceivedData(hData);
end;

Procedure TNDDEClWnd.CMUPoke(var Msg : TMessage);
var
  szTemp : array[0..42] of char;
  D : PInputDialog;
begin
  strcopy(szTemp, '');
  D := New(PInputDialog, init(@Self, AppTitle, 'Poke string : ', szTemp, sizeof(szTemp)));
  If Application^.ExecDialog(D) = IDOK then
    DDEClientTransaction(@szTemp, strlen(szTemp) + 1, Conv, hszItem, CF_Text, XTYP_POKE, 1000, NIL);
end;

Procedure TNDDEClWnd.CMUAdvise(var Msg : TMessage);
var
  hTempMenu : hMenu;
  TempResult : LongInt;
begin
  hTempMenu := GetMenu(hWindow);
  if GetMenuState(hTempMenu, Msg.wParam, MF_BYCOMMAND) = MF_UNCHECKED then
  begin
    if BOOL(DDEClientTransaction(NIL, 0, Conv, hszItem, CF_TEXT, XTYP_ADVStart + XTYPF_ACKREQ, 1000, @TempResult)) = TRUE then
    begin
      CheckMenuItem(hTempMenu, msg.wParam, MF_BYCOMMAND + MF_CHECKED);
      tfLoop := TRUE;
    end;
  end
  else
  begin
    if BOOL(DDEClientTransaction(NIL, 0, Conv, hszItem, CF_TEXT, XTYP_ADVStop, 1000, @TempResult)) = TRUE then
    begin
      CheckMenuItem(hTempMenu, msg.wParam, MF_BYCOMMAND + MF_UNCHECKED);
      tfLoop := FALSE;
    end;
  end;
  DrawMenuBar(hWindow);
end;

Procedure TNDDEClWnd.CMUHelpAbout(var Msg : TMessage);
begin
  MessageBox(hWindow, 'NDDECLI : A Network DDE Client'#13' Copyright G.T. Swindell 1993'+
                      #13' Copyright Borland International 1992', AppTitle, MB_ICONINFORMATION);
end;

Procedure TNDDEClWnd.ReceivedData(hData : hDDEData);
begin
  if hData <> 0 then
  begin
    DDEGetData(hData, @szData, Sizeof(szData), 0);
    InvalidateRect(hWindow, NIL, TRUE);
  end;
end;

Type
{ TNDDEClApp }

  PNDDEClApp = ^TNDDEClApp;
  TNDDEClApp = object(TApplication)
    Constructor Init(AName : PChar);
    Procedure InitMainWindow; virtual;
  end;

Constructor TNDDEClApp.Init(AName : PChar);
begin
  inherited init(AName);
end;

Procedure TNDDEClApp.InitMainWindow;
begin
  MainWindow := New (PNDDEClWnd, init(NIL, 'NDDECLI. (A Network DDE Client)'));
  ConvWindow := PNDDEClWnd(MainWindow);
end;


{ Main Loop }

Var
  ANDDEApp : TNDDEClApp;

begin
  With ANDDEApp do
  begin
    Init('Network DDE Client App');
    Run;
    Done;
  end;
end.