//͸
//  Program .....: G_Event                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "g_event.ch"
#include "g_menu.ch"
#include "inkey.ch"
#include "mouse.ch"

#define TO_SAVE  1
#define TO_OPEN  2

//Ŀ
//  Mouse Event Translation 
//
Function MouseEvent()

    LOCAL Event  := 0                                   , ;
          Mouse  := MouseSys()                          , ;
          x      := Current_Window()                    , ;
          Window := WinObj()                            , ;
          nRow                                          , ;
          nCol                                          , ;
          xwin                                          , ;
          i                                             , ;
          p


    nRow   := Mouse:Row
    nCol   := Mouse:Column

    if Mouse:Button == RIGHT_BUTTON
      Return( Event )
    endif

    if ! Window_Active()
      Return( Event )
    endif

    Do Case
      Case ( nRow == Window:TopRow - 3 .and. ;
           (nCol >= Window:RightColumn -5 .and. ;
            nCol <= Window:RightColumn -3 ))

           Event := ev_Up

      Case ( nRow == Window:TopRow - 3 .and. ;
           (nCol >= Window:RightColumn -2 .and. ;
            nCol <= Window:RightColumn ))

           Event := ev_Down

      Case ( nRow == Window:TopRow - 1 .and. ;
            ( nCol >= Window:LeftColumn .and. ;
              nCol <= Window:LeftColumn+1 ;
            ) ;
           )

           Event := ev_Left

      Case  ( nRow == Window:TopRow - 1 .and. ;
           ( nCol >= Window:RightColumn -1 .and. ;
            nCol <= Window:RightColumn ))

           Event := ev_Right

      Case ( nRow == Window:TopRow -4 .and. ;
            ( nCol >= Window:LeftColumn -1 .and. ;
              nCol <= Window:RightColumn +1 ))

           Event := ev_WindowMoveResize

      Case ( nRow == Window:BottomRow +1 .and. ;
            ( nCol == Window:LeftColumn -1 .or. ;
              nCol == Window:RightColumn +1 ;
            ) ;
           )
          Event := ev_WindowMoveResize

      Case (  nRow >= Window:TopRow-4 .and. ;
                    nRow <= Window:BottomRow+1 .and. ;
                    nCol >= Window:LeftColumn-1 .and. ;
                    nCol <= Window:RightColumn+1 ;
           ) .and. Mouse:Button == BOTH_BUTTONS

          Event := ev_WindowZoom

      Case (  nRow >= Window:TopRow .and. ;
                    nRow <= Window:BottomRow .and. ;
                    nCol >= Window:LeftColumn .and. ;
                    nCol <= Window:RightColumn ;
           ) .and. Mouse:Button == LEFT_BUTTON

         if Window:CurrentRow > nRow
           Window:Up(Window:CurrentRow - nRow)
         else
           Window:Down(nRow - Window:CurrentRow)
         endif

      Otherwise

         xwin := x
         p := len(win_stack())
         for i = 1 to Len(windows())
           if ! empty(WinFilename(xWin)).and.;
              (  nRow >= WinObj(xWin):TopRow-4 .and. ;
                 nRow <= WinObj(xWin):BottomRow+1 .and. ;
                 nCol >= WinObj(xWin):LeftColumn-1 .and. ;
                 nCol <= WinObj(xWin):RightColumn+1 ;
              )
              if xWin # x
                if ! empty(WinFilename(xWin))
                  DeHighLightWindow(x)
                else
                  loop
                endif
                HighLightWindow(xWin)
              endif
             exit
           Endif

           if p # 1
             xwin := win_stack()[--p]
           endif

         next

    EndCase

Return( Event )


//Ŀ
//  Menu Bar Event Translation 
//
Function MenuEvent( x )

    local Event := 0

    x := if( x == NIL, 0, x )

    Do Case

      Case x == ABOUT_ABOUT      ; Event := ev_About

      Case x == DATABASE_NEW     ; Event := ev_DataNew
      Case x == DATABASE_OPEN    ; Event := ev_DataOpen
      Case x == DATABASE_CLOSE   ; Event := ev_DataClose
      Case x == STRUCTURE_DISPLAY ; Event := ev_DataStructure

      Case x == INDEX_OPEN       ; Event := ev_IndexOpen
      Case x == INDEX_CLOSE      ; Event := ev_IndexClose
      Case x == INDEX_REORDER    ; Event := ev_IndexReorder
      Case x == VIEW_MODIFY      ; Event := ev_ViewModify

      Case x == SYS_EXIT         ; Event := ev_SysExit

      Case x == GO_REC           ; Event := ev_GoToRec
      Case x == LOCA_REC         ; Event := ev_LocateRec
      Case x == SEEK_REC         ; Event := ev_SeekRec

      Case x == WIN_NEXT         ; Event := ev_WindowNext
      Case x == WIN_PREV         ; Event := ev_WindowPrev
      Case x == WIN_MOVE         ; Event := ev_WindowMoveResize
      Case x == WIN_ZOOM         ; Event := ev_WindowZoom
      Case x == VIEW_VERT        ; Event := ev_WindowVertical
      Case x == VIEW_HORI        ; Event := ev_WindowHorizontal

      Case x == HELP_GEN         ; Event := ev_GenHelp
      Case x == HELP_WIN         ; Event := ev_WinHelp

    EndCase

Return( Event )



//Ŀ
// KeyBoard Event Translation 
//
Function KeyBoardEvent(x)

    LOCAL Event := 0, msColor := SetColor()

    x := if( x == NIL, 0, x )

    Do Case
      Case x == K_TAB            ;    Event := ev_WindowNext
      Case x == K_SH_TAB         ;    Event := ev_WindowPrev
      Case x == K_UP             ;    Event := ev_Up
      Case x == K_DOWN           ;    Event := ev_Down
      Case x == K_LEFT           ;    Event := ev_Left
      Case x == K_RIGHT          ;    Event := ev_Right
      Case x == K_CTRL_LEFT      ;    Event := ev_Left
      Case x == K_CTRL_RIGHT     ;    Event := ev_Right
      Case x == K_HOME           ;    Event := ev_Home
      Case x == K_END            ;    Event := ev_End
      Case x == K_CTRL_PGUP      ;    Event := ev_GoTop
      Case x == K_CTRL_PGDN      ;    Event := ev_GoBottom
      Case x == K_PGUP           ;    Event := ev_PageUp
      Case x == K_PGDN           ;    Event := ev_PageDown
      Case x == K_CTRL_HOME      ;    Event := ev_PanHome
      Case x == K_CTRL_END       ;    Event := ev_PanEnd
      Case x == K_INS            ;    Event := ev_QuickInsertBlank
      Case x == K_DEL            ;    Event := ev_QuickDelete

      Case x == K_ALT_1          ;    Event := x
      Case x == K_ALT_2          ;    Event := x
      Case x == K_ALT_3          ;    Event := x
      Case x == K_ALT_4          ;    Event := x
      Case x == K_ALT_5          ;    Event := x
      Case x == K_ALT_6          ;    Event := x
      Case x == K_ALT_7          ;    Event := x
      Case x == K_ALT_8          ;    Event := x
      Case x == K_ALT_9          ;    Event := x

      Case uppe(chr(x)) == 'F'   ;    Event := ev_DataOpen
      Case uppe(chr(x)) == 'I'   ;    Event := ev_IndexOpen
      Case uppe(chr(x)) == 'G'   ;    Event := ev_GoToRec
      Case uppe(chr(x)) == 'L'   ;    Event := ev_LocateRec
      Case uppe(chr(x)) == 'S'   ;    Event := ev_SeekRec

      Case x == K_ALT_F1         ;    Event := x

        SetColor("W+/R")
        WinBox( 8, 15, 16, 64,,5, .t. )
        @  9,18 say 'Garbage Collection..............:' + str(memory( -1  )) + "K"
        @ 10,18 say 'Fixed Head......................:' + str(memory( 101 )) + "K"
        @ 11,18 say 'Character Space.................:' + str(memory( 0 )) + "K"
        @ 12,18 say 'Largest Block...................:' + str(memory( 1 )) + "K"
        @ 13,18 say '................................:' + str(memory( 2 )) + "K"
        @ 14,18 say 'EMS Available to VMM............:' + str(memory( 3 )) + "K"
        @ 15,18 say 'EMS and Disk Available to VMM...:' + str(memory( 4 )) + "K"
        inkey(0)
        SetColor(msColor)
        ShowBackGround()
        ShowDeskTop()

    EndCase

Return( Event )


//Ŀ
//   Event Processing 
//
Function EventProcess( Event )

    local Window := WinObj(), Mouse := MouseSys()

    Event := if( Event == NIL, 0, Event )

    Mouse:Hide()
    Do Case
      Case Event == ev_About ; GrayBar() ; g_about() ; UnGrayBar()

      Case Event == ev_DataOpen
        DehighlightWindow()
        GrayBar()
        g_DataOpen()
        UnGrayBar()
        OpenWindow()


      Case Event == ev_GenHelp .or. ;
           Event == ev_WinHelp
        GrayBar()
        g_help( Event )
        UnGrayBar()

    EndCase

    if ! Window_Active()
      Mouse:Hide()
      Return( Event )
    endif

    Do Case
      Case Event == ev_DataNew
      Case Event == ev_DataClose         ;       g_Dataclose()

      Case Event == ev_WindowNext        ;       WinNext()
      Case Event == ev_WindowPrev        ;       WinPrev()
      Case Event == ev_WindowZoom        ;       WinZoom()

      Case Event == ev_WindowMoveResize
        WinResize()

      Case Event == ev_ViewModify
        GrayBar()
        g_ViewCreate()
        UnGrayBar()
        OpenWindow()

      Case Event == ev_WindowVertical    ;  g_Record()
      Case Event == ev_WindowHorizontal  ;  g_Browse()


      Case Event == ev_Left
        if Window:UserSlot[2] == NIL
          Window:Left()
        endif

      Case Event == ev_Right     
        if Window:UserSlot[2] == NIL
          Window:Right()
        endif

      Case Event == ev_PanHome
        if Window:UserSlot[2] == NIL
          Window:PanHome()
        endif

      Case Event == ev_PanEnd
        if Window:UserSlot[2] == NIL
          Window:PanEnd()
        endif

      Case Event == ev_Up        ;  Window:Up()
      Case Event == ev_Down      ;  Window:Down()
      Case Event == ev_Home      ;  Window:Home()
      Case Event == ev_End       ;  Window:End()
      Case Event == ev_GoTop     ;  Window:GoTop()
      Case Event == ev_GoBottom  ;  Window:GoBottom()
      Case Event == ev_PageUp    ;  Window:PageUp()
      Case Event == ev_PageDown  ;  Window:PageDown()

      Case Event == K_ALT_1    ;  GotoWin(1)
      Case Event == K_ALT_2    ;  GotoWin(2)
      Case Event == K_ALT_3    ;  GotoWin(3)
      Case Event == K_ALT_4    ;  GotoWin(4)
      Case Event == K_ALT_5    ;  GotoWin(5)
      Case Event == K_ALT_6    ;  GotoWin(6)
      Case Event == K_ALT_7    ;  GotoWin(7)
      Case Event == K_ALT_8    ;  GotoWin(8)
      Case Event == K_ALT_9    ;  GotoWin(9)

      Case Event == ev_IndexOpen          ; GrayBar() ; g_indexopen()   ; UnGrayBar()
      Case Event == ev_IndexReorder       ; GrayBar() ; g_indexorder()  ; UnGrayBar()
      Case Event == ev_IndexClose         ; GrayBar() ; g_indexClose()  ; UnGrayBar()
      Case Event == ev_GoToRec            ; GrayBar() ; g_Goto()        ; UnGrayBar()
      Case Event == ev_LocateRec          ; GrayBar() ; g_Locate()      ; UnGrayBar()
      Case Event == ev_SeekRec            ; GrayBar() ; g_seek()        ; UnGrayBar()


    EndCase

    Mouse:Show()
    Window_Active( ! Empty(alias()) )

Return( NIL )


static function GotoWin( x )

    if ! Empty(Winfilename(x))
      DeHighLightWindow()
      Current_Window(x)
      HighLightWindow()
    endif

Return( NIL )
