/* Program: EQUIP.C                                    */
/* Authors: Gerry Braganza and Diane Lask              */
/* Version: Clipper Summer '87                         */
/* Note(s): Equipment attached to the computer as well */
/*          as keyboard status and system ID.          */
/*                                                     */
/* Copyright (c) 1989 Nantucket Corp.                  */

#include "\fix\nandef.h"     /* As Nantucket defines it.   */
#include "\fix\extend.h"     /* Nantucket's extend header. */ 
#include "\include\stdio.h"


#define EQLIST      0x410    /* BIOS int 17 equipment list.*/
#define MEMSIZ      0x413    /* BIOS int 8 memory size.    */
#define KEY_STAT    0x417    /* Current keybd status bits. */


CLIPPER Eq()

{

/* Input and return parameters. */

int p_input;
int p_return;

/* Mempeek holds an integer from anywhere in memory. */
unsigned far *mempeek;         
			       

/* Check for proper parameter from Clipper. */
if (ISNUM(1))
    {
      p_input = _parni(1);
    }
else
    {
      /* Display error message. */
      printf("Type Mismatch \n");
      exit();
    }

/* Look at BIOS equipment list. */
mempeek =  (int *) EQLIST;     

/* Check parameter. */
switch (p_input)
   {
   case 1:                                   

        {
           /* DMA chip */                            
           p_return = ((*(mempeek) & 1) ? 1:0); break;    
        }                                    

   case 2:                                   

        {                                    
          /* no. of printers */
          p_return = *(mempeek) >> 14; break; 
        }                                    

   case 3:

        {
          /* no. of serial ports */
      	  p_return =  (*mempeek >> 9) & 7; break;
        }

   case 4:
        {
          /* number of diskette drives */
      	  if  (( *mempeek) & 1)
           {
	      p_return = (( *mempeek >> 6) & 3) + 1; break;
           }
          else
           {
	      p_return = 0; break;
           }
        }

   case 5:

       /* video mode */
       switch   (*mempeek & 48)
        {
           case 16: p_return = 40; break;
           case 48: p_return = 80; break;
           case 32: p_return = 80; break;
	   default: p_return = 0;  break;
      	}
      	break;

   case 6:             
        {
          /* look at BIOS memory size */
          mempeek =  (int *) MEMSIZ;
          p_return =  *mempeek;
          break;
        }
   case 7:                 
        {
          /* look at keyboard status and display */
          mempeek =  (int *) KEY_STAT;
          /* insert caps */
          p_return = (( *mempeek >> 7) & 1) ? 1:0;
          break;
        }
    case 8:
        {
          /* Caps Lock */
          mempeek =  (int *) KEY_STAT;
          p_return = (( *(mempeek) >> 6) & 1) ? 1:0; 
          break;
        }
   case 9:
        {
          /* Num Lock */
          mempeek =  (int *) KEY_STAT;
          p_return = ((( *(mempeek) >> 5) & 1) ? 1:0); 
          break;
        }
   case 10:
        {
          /* Scroll Lock */
          mempeek =  (int *) KEY_STAT;
          p_return = ((( *(mempeek) >> 4) & 1) ? 1:0); 
          break;
        }
   case 11:                   
        {
          /* look at ROM machine ID byte and display */
          mempeek = (int *) 0xF000FFFE;
          switch ( *(mempeek) & 255)
            {
               /* for a PC */
               case 255: 
                   p_return = 255;break;

               /* for a PC XT */
               case 254: 
                   p_return = 254;break;

               /* for a PC jr. */
               case 253: 
                   p_return = 253;break;

               /* for a PC AT , XT/286, PS2/50, PS2/60 */
               case 252: 
                    p_return = 252;break;

               /* for a XT/2  */
               case 251: 
                    p_return = 251;break;

               /* for a PC CVT */
               case 249: 
                    p_return = 249;break;
         
               /* for a PS/2 30 */
               case 248: 
                    p_return = 248;break;

               /* for a PS/2 80 */
               case 247: 
                    p_return = 247;break;
            }
       break;
       }
   /* If none of the available choices ? */
   default:
        {
        p_return = -1;break;
        }
   }

 /* Returns an integer to Clipper. */
 _retni(p_return);   

}  /* End of Eq() */ 
