* Program: Help.prg
* Author:  Benjo Dans 
* Version: Clipper Summer '87
* Note:    Disk-based help program
* Copyright (c) 1988 Benjo Dans

* ... code

PARAMETERS call, line, input

IF call = "HELP"        && Prevent recursive help
   RETURN               && from within the help program.
ENDIF

PRIVATE call, photo, slct, first
PRIVATE mrow, mcol, mkey, maxline, test, curline, scrnline
SAVE SCREEN TO photo

slct  = SELECT()        && Remember current work area.
first = .T.             && In case of no find, no redraw.   
mrow  = ROW()           && Store initial row, column pointers.
mcol  = COL()
mkey  =  0              && ASCII value of last key pressed.

SELECT 0                              && Open a work area.   
USE Help.dbf                          && Open help file.
GOTO TOP
DO WHILE .NOT. EOF() .AND. mkey <> 27 && Check for <ESC> key. 
   test = Condition                   
   IF &test.                          && Check for condition.
      first   = .F.                   && Set find flag.
      maxline = MLCOUNT(Notes,Width)  && Total memo lines.
      curline =  0                    && current memo line.

      * Display help screen(s) routine.
      DO WHILE curline < maxline .AND. mkey <> 27
         FOR scrnline  = 1 TO ;
         IIF(maxline > curline + Lines, Lines, maxline-curline)
             @ Row-1+scrnline, Col SAY ;
               MEMOLINE(Notes, Width, curline+scrnline)
         NEXT
         curline = curline + Lines 
         mkey    = INKEY(0)         && Pause screen.
     ENDDO
  ENDIF
  SKIP
ENDDO
USE                                  && Close help file.
SELECT (slct)                        && Restore work area.  
IF .NOT. first
   RESTORE SCREEN FROM photo         && Restore screen.
   @ mrow, mcol SAY ""               && Restore cursor position.
ENDIF
RELEASE ALL
RETURN
