* Function: Filecopy()
* Author:   Don L. Powells
* Version:  Clipper Summer '87
* Note(s):  Copy specified file to target disk.
*
* Copyright (c) 1988 Nantucket Corp.

FUNCTION Filecopy
PARAMETERS mfile, mdrive2
mtarget = mdrive2 + mfile
@ 24,0
IF Diskspace(Disknum(SUBSTR(mdrive2,1,1))) >= Filesize(mfile)
   @ 24,0 SAY "Copying " + TRIM(mfile) + " to " + mdrive2 + "..."
   COPY FILE &mfile. TO (mtarget)
   @ 24,0
ELSE
   @ 24,0 SAY "Not enough space for file. " +;
              "<ESC> to abort or any key to continue copying."
   mkey = INKEY(0)
   @ 24,0
   IF mkey = 27
      BREAK
   ELSE
      @ 24,0 SAY "Copying " + TRIM(mfile) + " to " +;
         mdrive2 + "..."
      COPY FILE &mfile. TO (mtarget)
      @ 24,0
   ENDIF
ENDIF
RETURN(.T.)


* Disknum()
* Converts a disk drive letter into an integer.
*
FUNCTION Disknum
PARAMETERS mletter
mletter = UPPER(mletter)
RETURN(AT(mletter,"ABCDEFGHIJKLMNOPQRSTUVWXYZ"))


* Filesize()
* Return the size of specified file in bytes.
*
FUNCTION Filesize
PARAMETERS mfile2
PRIVATE sizearray[1]
AFILL(sizearray,0)
msize = ADIR(mfile2,.F.,sizearray)
RETURN(sizearray[1])
