*  Program: MultiSel.prg       (Multiple Select)
*  Author:  David R. Alison
*  Version: Clipper Summer '87
*  Notes:   Example of multiple choice selection
*           with ACHOICE().
*  Public Domain Software.

PUBLIC mre, mel

**  Here we declare our array of menu choices...
DECLARE reports[10]
reports[1] = 'Customer Master List            '
reports[2] = 'Customer Mailing List           '
reports[3] = 'Parts List by Part Number       '
reports[4] = 'Parts List by Name              '
reports[5] = 'Parts List by Machine           '
reports[6] = 'Machine Failure Analysis        '
reports[7] = 'Average Parts Cost per Machine  '
reports[8] = 'Average Labor Cost per Machine  '
reports[9] = 'Current Inventory Status        '
reports[10]= 'Current Machine MTBF            '

**  Create the screen for menu selection
CLEAR
frame = 'ͻȺ'
@ 4, 23, 15, 58 BOX frame
@ 16, 23, 20, 58 BOX frame
@ 17, 26 SAY 'Press Enter to check off each'
@ 18, 26 SAY 'report to print.  F5 tags all,'
@ 19, 26 SAY 'F6 untags all.  Esc exits...'

**  mel & mre are public memvars that are modified 
**  by the ACHOICE UDF "getfield."  A UDF is used
**  because we are only going to flag the field
**  with a check mark.  This way the user can select
**  several fields.  The enter key acts as a toggle
**  for the flag.  If a flag is already there, it
**  removes it and vice versa.
mel = 1         && Initial choice element
mre = 1         && Initial relative window row
choice = 0      && Menu choice

**  Here is the meat of the program.  We will loop
**  through the ACHOICE() function until the user
**  presses Enter.  Then we will call the UDF "getfield"
**  which merely changes the public memvars mel and 
**  mre to reflect the position of the cursor within 
**  ACHOICE.
DO WHILE 1 = 1
   choice = ACHOICE(5, 25, 14, 57, reports, .t., ;
            "getfield", mel, mre)
   DO CASE
        
      **  Checks to see if the last key the user
      **  selected was the enter key.  If so, modify
      **  the reports array element to either add or
      **  remove the check mark.  Then loop back
      **  through the DO WHILE loop and call another
      **  ACHOICE.
      CASE lastkey() = 13
      IF substr(reports[choice],32,1) = chr(251)
         reports[choice] = substr(reports[choice],1,31)+' '
      ELSE
         reports[choice] = substr(reports[choice],1,31)+chr(251)
      ENDIF

      **  If the last key pressed was the F5 key,
      **  tag all of the items, regardless of current
      **  status
      CASE lastkey() = -4
      FOR i = 1 TO 10
         reports[i] = substr(reports[i],1,31)+chr(251)
      NEXT

      **  If the last key pressed was the F6 key,
      **  untag all of the items, regardless of current
      **  status
      CASE lastkey() = -5
      FOR i = 1 TO 10
         reports[i] = substr(reports[i],1,31)+' '
      NEXT

      **  If the last key pressed was the Esc key,
      **  exit the loop.
      CASE lastkey() = 27
      EXIT

   ENDCASE
ENDDO

CLEAR

**  Determine which reports were selected and generate them.
FOR i = 1 TO 10
   IF substr(reports[i],32,1) = chr(251)  && Is there a check?
      reports[i] = trim(substr(reports[i],1,31))
      ? 'Printing the "'+ reports[i] + '" report.'
   ENDIF
NEXT

FUNCTION getfield
**  Function for use with ACHOICE().  Returning
**  the 1 tells ACHOICE() to continue with the
**  selection process.
PARAMETERS mode, element, relative
mel = element
mre = relative
RETURN(1)

* EOP: MULTISEL.PRG
