* Program: HELPRITE.PRG
* Author:  Don L. Powells
* Version: Clipper Summer 87
* Notes:   Database file: HELP.DBF
*          Index file: HELP.NTX
*          Routine to edit and save user-defined help messages
* Copyright (c) 1988 Nantucket Corp.
*
SET KEY -30 TO
PARAMETERS call_prg, line_num, input_var
helpscrn = SAVESCREEN(8,20,18,59)
wkarea = SELECT()
ismemo = .F.
SELECT 0
USE Help
IF FILE("HELP.NTX")
   SET INDEX TO Help     && Index Key: Proc+STR(Line)+Get_var
ELSE
   INDEX ON Proc + STR(Line) + Get_var to Help
ENDIF

* Draw Help Display Box
@ 8,20 TO 18,59
@ 8,53 SAY CHR(24) + " PgUp"     && 24 = UpArrow
@ 18,53 SAY CHR(25) + " PgDn"    && 25 = DnArrow
CENTER(8,"Help Entry")
CENTER(18,"Press Ctrl-W when Done")
* Clear out inside of the box
SCROLL(9,21,17,58,0)

* Ensure that the call_prg and input_var are 10 chars long
*   so that they will match the index key value and dbf
sought = IIF(LEN(call_prg) < 10, call_prg +;
         SPACE(10 - LEN(call_prg)),SUBSTR(call_prg,1,10)) +;
         str(line_num) + IIF(LEN(input_var) < 10, input_var +;
         SPACE(10 - LEN(input_var)),SUBSTR(input_var,1,10))
SEEK sought
IF FOUND()
   ismemo = .T.
   helpnotes = Help_memo
ELSE
   helpnotes = space(400)
ENDIF
SET CURSOR ON
helpnotes = MEMOEDIT(helpnotes,9,21,17,58,.T.)
resp = "Y"
CENTER(18,"Save Help Message(Y/N)? ")
resp = INKEY(0)
IF UPPER(CHR(resp)) = "Y"
   IF !ismemo
      APPEND BLANK
   ENDIF
   REPLACE Proc WITH call_prg, Line WITH line_num,;
      Get_var WITH input_var
   REPLACE Help_memo WITH helpnotes
ENDIF
USE
SELECT (WKAREA)
RESTSCREEN(8,20,18,59,helpscrn)
SET KEY -30 TO Helprite
RETURN

