/* =================== blink.c =================
* 9:34:28  2/17/1988  ldv
* Carson Lee
* Copyright 1988 SourceMate Information System Inc.
* 20 Sunnyside, Mill Valley, Ca 94941
* 415-381-1011
* ============================================== */


#include "nandef.h"
#include "extend.h"
#include "dos.h"
#define peekb(a) ( * (( unsigned char far * ) ( a ) ))





/* ------------ blinkoff --------------
* 9:34:47  2/17/1988  ldv
* Carson Lee
* Copyright 1988 SourceMate Information System Inc.
* function to turn on background intensity under Clipper
* there are no calling parameters and no return value
* ------------------------------------ */
CLIPPER blinkoff()
{

 union REGS regs;
 unsigned int port;

 /* --- take care of ega / vga adapters --- */
 regs.h.ah = 0x10;
 regs.h.al = 3;
 regs.h.bl = 0;
 int86( 0x10, &regs, &regs );

 /* --- take care of color / mono adapters --- */
 if ( peekb( 0x449 ) == 7 )    /* check if color or mono */
   port = 0x3b8;               /* mono */
 else
   port = 0x3d8;               /* color */

 outp( port, peekb( 0x465 ) & 0xdf );  /* blink off */

 _ret();

} /* ------ blinkoff.eof.ldv ----- */




/* ------------ blinkon -------------
* 9:35:07  2/17/1988  ldv
* Carson Lee
* Copyright 1988 SourceMate Information System Inc.
* function to turn off background intensity under Clipper
* there are no calling parameters and no return value
* ------------------------------------ */
CLIPPER blinkon()
{

 union REGS regs;
 unsigned int port;

 /* --- take care of ega / vga adapters --- */
 regs.h.ah = 0x10;
 regs.h.al = 3;
 regs.h.bl = 1;
 int86( 0x10, &regs, &regs );

 /* --- take care of color / mono adapters --- */
 if ( peekb( 0x449 ) == 7 )    /* check if color or mono */
   port = 0x3b8;               /* mono */
 else
   port = 0x3d8;               /* color */

 outp( port, peekb( 0x465 ) | 0x20 );  /* blink on  */

 _ret();

} /* ------- blinkon.eof.ldv ------ */




/* ================ blink.c.eof.ldv ==================== */
