* Program Name: tpackmem.prg * 
* Author: Don L. Powells * 
* (c) 1987 by D. P. & Associates * 
* Created: 8/21/1987 at 15:45 *
 
set color to w/b,b/w,b,b,w/b 
clear 
fname = space(64) 
? "                          TPACKMEM.PRG" 
? 
? "     This program demonstrates the mpack program written "+;
        "in C." 
?"   mpack packs the dbt file holding the memos for the "+;
     "specified dbf."
 
* Get filename
@ 8,5 say "Enter a dbf filename with no extension: "  
@ 9,5 get fname 
read 
 
* Append proper extensions to filename
dbffname = trim(fname) + ".dbf" 
dbtname = trim(fname) + ".dbt" 

* Check to see if there is enough diskspace to execute the
* function
if diskspace(0) < filesize(dbtname)
   ? chr(7)
   ? "There is not enough disk space to safely execute this "+;
     "function."
   return
endif

* Save the original files to temp files for use with mpack
copy file &dbtname to temp#.dbt>nul 
copy file &dbfname to temp#.dbf>nul 

* Pack the file with the COPY TO method
@ 5,0 clear 
@ 7,5 say "Packing " + trim(fname) + ".dbt. with COPY TO method." 
stime = seconds() 
use &fname 
copy to temp 
close databases 
erase &dbfname 
erase &dbtname 
rename temp.dbf to &dbfname 
rename temp.dbt to &dbtname 
etime = seconds() 
?? chr(7) 
run_time = etime - stime 
? alltrim(str(run_time)) 
?? " seconds elapsed." 
 
* Restore temp files to original files
copy file temp#.dbt to &dbtname>nul 
copy file temp#.dbt to &dbfname>nul 

* Pack using the mpack method
oldsize = filesize(dbtname) 
@ 9,5 say "Packing " + trim(fname) + ".dbt. with MPACK()." 
stime = seconds() 
errnum = mpack(trim(fname)) 
etime = seconds() 
run_time2 = etime - stime 
 
?? chr(7) 
? "The error code returned by MPACK() is: " 
?? errnum 
?

* Translate the error code into a message 
DO CASE 
   case errnum = 0 
      ? "The memo pack was successfully accomplished!!!" 
   case errnum = 1 
      ? " An improper number of parameters was passed or the "+;
        "parameter " 
      ? "    passed was not a character." 
   case errnum = 2 
      ? " The .dbf file could not be opened. There may not be "+;
        "any file " 
      ? "    handles available. The file may not exist. The "+;
        "attributes may" 
      ? "    be set to hidden." 
   case errnum = 3 
      ?" There was an error reading the signature byte of the "+;
       ".dbf" 
      ?"     header." 
   case errnum = 4 
      ? " The signature byte was not 83H. The .dbf file is a "+;
        "dBASE file" 
      ? "     with a memo field." 
   case errnum = 5 
      ? " There was a problem renaming the old .dbt file. "+;
        "There may" 
      ? "    already be a file in the current directory called " 
      ? "    cpackmem.bak. The .dbt file may not be in the "+;
        "current " 
      ? "    directory." 
   case errnum = 6 
      ? " Can not open the old .dbt file." 
   case errnum = 7 
      ? " Can not create new .dbt file. There may be no file "+;
        "handles " 
      ? "    available. The disk may be full." 
   case errnum = 8 
      ? " Read error reading the first 512 bytes of the old "+;
        ".dbt file." 
   case errnum = 9 
      ? " Write error writing the first 512 bytes of the new "+;
        ".dbt file." 
   case errnum = 10 
      ? " Error moving pointer through .dbf file." 
   case errnum = 11 
      ? " Read error reading the .dbf header." 
   case errnum = 12 
      ? " Error moving pointer to first field descriptor in "+;
        ".dbf file." 
   case errnum = 13 
      ? " Read error reading first field descriptor in .dbf "+;
        "file." 
   case errnum = 14 
      ? " Read error reading a field descriptor in .dbf file." 
endcase 
 
* Report results of function
? alltrim(str(run_time2)) 
?? " seconds elapsed when packing with MPACK()." 
? "MPACK requires "  
?? alltrim(str((run_time2/run_time)*100))+"% of the time "+;
   "required by COPY TO method." 
newsize = filesize(dbtname) 
? "Original file size= " + alltrim(str(oldsize)) + space(4) +; 
   "New dbt file size= " + alltrim(str(newsize)) 
saved = oldsize-newsize 
? alltrim(str(saved)) + " bytes were saved by packing." 
wait 
return 
