	TITLE FLIPSTR
	PAGE ,132
;
;   Title:    TURNIT3.ASM
;   Author:   F. Ho
;   Date:     8th July 1986
;   Syntax:   ? TURN(expC)
;             where: -expC is the character string expression 
;                     to be reversed
;   Note:     - reverses the order of the string passed
;             - can only process a MAX of 60 characters

;   Revised PBaenziger, pbprograms, 1215 Lane, Kalamzoo, MI 49001
;   (616) 349-9720 (Evenings), 323-7392 (Days, 8-4:30 EDT)

;   Simplified, using string instructions
;   Maximum string length MAXLEN - set for debugging to 10 decimal
;
public	TURN      ; this public statement makes this
;                  ; routine accessible to the 'public'
;
extrn    _PARC:far           ; Clipper's character 'getter'
extrn    _RETC:far           ; Clipper's character 'returner'
;
;
MAXLEN   EQU       10             ; Maximum string length

DGROUP   GROUP     datasg         ; Clipper's Data Segment

; the 'public' in the next statement combines the datasg
; to Clipper's DGROUP group
datasg   segment   public    'DATA'

RETVAL   db        MAXLEN + 1 dup(?)   ; Space for flipped string + NUL

datasg   ends                     ; end of datasg (in DGROUP)
;
;
_prog    segment
assume   cs:_prog,ds:DGROUP, ES:NOTHING

TURN     proc      far            ; far process
		
         mov       ax,1           ; get first para
         push      ax             ; push AX
         call      _PARC          ; call Chara "getter"
         add       sp,2           ; restore stack

         MOV       DI, BX         ; Offset of incoming param string
         MOV       ES, AX         ; Segment of incoming param string
		
         ; DS is pointing to DGROUP
         LEA       BX, DGROUP:RETVAL
         MOV       DX, DS               ; Save DGROUP segment for later
		
         ; ES:DI point to start of parm string
         ; DS:BX point to start of RETVAL
         ; AX still holds parm string segment
         ; DX also holds DGROUP/RETVAL segment
         ; Now sort out null string special case
         MOV       CL, ES:[DI]     ; Check for null parameter string
         OR        CL, CL          ; Is it NULL?
         JNZ       T010            ; Not zero, so skip, it's a regular string
		
         ;Null string special case
         MOV       [BX], CL            ; Put a null into RETVAL
         JMP       SHORT C3
		
		
         ASSUME    DS:NOTHING

T010:    MOV       DS, AX              ; Also for later use as source
		
         ; Find terminating 0
         cld                           ; String instructions upwards
         MOV       CX, MAXLEN	   	; Maximum length that RETVAL
                                       ; can accommodate
         SUB       AL, AL              ; Compare value - NUL, zero
		
         ; Check thru string for terminating 0
         REPNE     SCASB               ; Look for nul
         ; DI points one beyond 0
         JNZ       T020                ; No terminating null found, 
                                       ; counted down
         ; Null found, DI points one beyond null
         INC CX
         DEC DI                   ; Now points to null
		
T020:    DEC       DI             ; And now points to last character
         SUB       CX, MAXLEN	; Negative length of string
         NEG       CX             ; Actual length of string (except for nul)

         MOV       SI, DI         ; End of string is source
                                  ; DS is already set to right segment
         ;DS:SI point to last char of parm string
         ;BX currently holds offset, DX segment of RETVAL
         ;Move it into ES:DI
         MOV       ES, DX         ; Save it for later in BX
         ASSUME    ES:DGROUP
         MOV       DI,BX

A3:      mov       al,[si]        ; Get a source character
         dec       si             ; and point to next
         STOSB                    ; and put AL into target pointed
                                  ; to by ES:DI, autoincrement of DI
         loop      A3             ; loop - count down CX
	
         xor       AL,AL          ; zero-out al
         STOSB                    ; add null terminator to end
                                  ; of RETVAL
         ; DX:BX hold RETVAL starting offset
         MOV       DS, DX         ; Restore original DS - DGROUP

C3:      PUSH      DS             ; Segment
         PUSH      BX             ; Offset
         call      _RETC          ; Clipper's  "returner"
         ADD       SP, 4          ; Clean stack
		
         ret                      ; actual ret to caller
TURN     endp                     ; end of process

_prog    ends                     ; end of segment
         end                      ; end of programme
;
;
