Define TestWinputComboFormat(key, type) {
    if (type != "s")
        return key;
    return key. "\t\t". univ^[key]. "\t";
}
Define TestWinputMandatory(hand, value, name) {
    if (!value) {
        MsgWait("", "Field " . name . " must be entered");
        return 1;
    }
}
Define TestWinput 
/*
    Demonstrate all the widgits in Screen Dialogues
*/
{
    scr = SdCreate("Winput", -1, -1, 16, 65, 
                    "Screen Task ". TaskNum(). " at level ". Level());
    var    = "QWERTY";
    vrad   = "y";
    vchk   = "c";
    vsel   = "attn";
    vcom   = "clnt";
    vint   = 889977;
    vfloat = 1234.56;
    vdate  = "14/2/1983";

    SdMenu(scr, "main", 1, "Action",    "a", 145,
                        1, "Utilities", "u", 117,
                        1, "Invoice",   "i", 115,
                        1, "Help",      "h", 4);

    SdPopup(scr, "inv",  115, 1, "Option a",   "a", 138,
                             1, "Option b",   "b", 139,
                             1, "Option c",   "c", 140);

    SdPopup(scr, "optb", 139, 1, "Option ba",  "a", 141,
                             1, "Option bb",  "b", 142);

//  SdPopup(scr, "optc", 140, 1, "Option ca",  "a", 143,
//                           1, "Option cb",  "b", 144);

    SdPopup(scr, "ute",  117, 1, "Colours",    "c", 125,
                             1, "Printers",   "p", 127);

    SdPrompt(scr,            1,  1, "Prompty", "p");
    SdString(scr, "f0",   1, 1,  9, 8, &var, , "caret", "TestWinputMandatory");
    SdPrompt(scr,            2,  1, "Int");
    SdInt   (scr, "int",  1, 2,  9, 8, &vint);
    SdPrompt(scr,            3,  1, "Float");
    SdFloat (scr, "floa", 1, 3,  9, 8, &vfloat, 2);
    SdPrompt(scr,            4,  1, "Date");
    SdDate  (scr, "date", 1, 4,  9, 10, &vdate);

    SdButton(scr, "b0",   1, 1, 21, 10, "Disable", "d", 105);
    SdButton(scr, "b1",   1, 2, 21, 10, "Enable", "e", 106);
    SdButton(scr, "ok",   1, 3, 21, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 4, 21, 10, "Cancel", "", 2);
    SdButton(scr, "abr",  1, 5, 21, 10, "Exit", "", 111);
    SdRadio (scr, "r0",   1, 1, 35, 12, &vrad, "Radio x", "x", 107);
    SdRadio (scr, "r1",   1, 2, 35, 12, &vrad, "Radio y", "y", 108);
    SdRadio (scr, "r2",   1, 3, 35, 12, &vrad, "Radio z", "z", 109);
    SdButton(scr, "szc",  1, 5, 31, 10, "SizeChg", "", 112);
    SdCheck (scr, "c0",   1, 1, 50, 12, &vchk, "Check", "c", 110);
    SdCheck (scr, "c1",   1, 2, 50, 15, &repa, "Report Action", "r");

    SdCombo (scr, "com",  1, 7,  1, 25, 7, &vcom, "univ^", 134, 
                                       "TestWinputComboFormat", 52,,137);
    SdMultiLine(scr, "ml", 1, 9, 1, 25, 5);
    SdSelect(scr, "sel",  1, 7, 31, 22, 7, &vsel, "univ^ptyp_code^", 
                                        133,,135, 136);
    SdFieldCols(scr, "com", -20, 4, 20);
    SdString(scr, "comv", 1, 15, 1, 50, "");

    while ((action = SdEdit(scr, "N"))) {
        if (action == 2 || action == 3)
            break;
        else if (action == 111)
            Exit("Program terminated at users request");

        SdUpdate(scr);

        switch (action) {
        case 133:
            pre = "(s) - ";         // selected
            goto SH_SELECT;
        case 135:
            pre = "(d) - ";         // double clicked
            goto SH_SELECT;
        case 136:
            pre = "(m) - ";         // moved
        SH_SELECT:
            SdFieldSet(scr, "comv", pre . univ^ptyp_code^[vsel]);
            continue;
        case 134:
            pre = "(s) - ";         // selected
            goto SH_COMBO;
        case 137:
            pre = "(d) - ";         // double clicked
        SH_COMBO:
            SdFieldSet(scr, "comv", pre . univ^[vcom]);
            continue;
        case 138:
            OptionA();
            break;
        case 112:
            sztoggle = sztoggle ? 0 : 1;
            SdPrompt(scr,            1,  1, "Prompt" . (sztoggle ? "" : "y"), "p");
            SdString(scr, "f0",   1, 1,  9, sztoggle ? 10 : 8, &var, , "caret", "TestWinputMandatory");
            SdButton(scr, "ok",   1, 3, 21, sztoggle ? 12 : 10, "OK", "", 1);
            SdButton(scr, "can",  1, 4, 21, sztoggle ? 12 : 10, "Cancel", "", 2);
            SdButton(scr, "szc",  1, 5, 31, sztoggle ? 12 : 10, "SizeChg", "", 112);
            SdCombo (scr, "com",  1, 7,  1, sztoggle ? 20 : 25, 
                                            sztoggle ? 5 : 7, &vcom, 
                                            "univ^", 134, "TestWinputComboFormat", 
                                            52,,137);
            SdSelect(scr, "sel",  1, sztoggle ? 8 : 7, sztoggle ? 35 : 31, 
                                            sztoggle ? 15 : 22, 
                                            sztoggle ? 5 : 7, &vsel, 
                                            "univ^ptyp_code^", 133, , 135, 136);
            SdFieldCols(scr, "com", -20, 4, 20);
            if (sztoggle)
                SdMultiLine(scr, "ml", 1, 10, 2, 20, 3);
            else
                SdMultiLine(scr, "ml", 1, 9, 1, 25, 5);
            SdString(scr, "comv", 1, sztoggle ? 14 : 15, 
                                     sztoggle ? 3 : 1, 
                                     sztoggle ? 40 : 50, "");
        }

        if (repa)
            MsgWait("NADIR task " . TaskNum(), 
                    "action is " . action .
                    "\nstring is " . var . 
                            (SdFieldMod(scr, "f0") ? " (modified)" : "") .
                    "\nint is " . vint .
                    "\nfloat is " . vfloat .
                    "\ndate is " . vdate .
                    "\nradio is " . vrad .
                    "\ncheck is " . vchk .
                    "\nselect is " . vsel .
                    "\ncombo is " . vcom);

        if (action == 105 || action == 106)
            SdModeSet(scr, action == 106, "f0", "b0", "r0", "r1", "r2", "c0");
    }
    SdDestroy(scr);
}
Define OptionA {
    scr = SdCreate(, -2, -2, 14, 60, 
                "Option A ". TaskNum());
    var = "QWERTY";
    SdPrompt(scr, 1, 2, "Prompty", "p");
    SdString(scr, "f0", 1, 1, 10, 8, &var);
    SdButton(scr, "ok", 1, 3, 20, 8, "OK", "", 1);
    SdButton(scr, "can", 1, 4, 20, 8, "Cancel", "", 2);
    while ((action = SdEdit(scr, "N")) == 1) {
        SdUpdate(scr);
        MsgWait("Option A", "OK button pressed !");
    }
    SdDestroy(scr);
}
Define TestMsgCreate(table) {
    if (!table)
        table = "univ";
    scr = MsgCreate("Test Interruptable Messages - Symbols in ". table);
    while (!abort) {
        code = "";
        while (code = next([table]^[code])) {
            if (abort = MsgShow(scr, "Listing " . code))
                break;
        }
    }
    MsgDestroy(scr);
}
