Define ShowArgs()
/*
    test and demonstrate the way to address arguments using argc and argv.
    argc is a special language variable that returns the number of 
    arguments passed to the current function.
    argv[n] will return the value of the nth argument to the current
    function.  argv[0] returns the first argument.  If an argument
    is undefined, the null string is returned.
*/
{
    Print("Called with ", argc, " args\n");
    for (i = 0; i < argc; i += 1) {
        Print(argv[i], " ", FieldType(argv[i]), "\n");
    }
}

ShowArgs(1,2,3,4,5,6,7,8,9,10,11,12)//====

ShowArgs("aaaa","bbbb","cccc")//====

ShowArgs()//====

ShowArgs(aaaa, bbbb, cccc cccc, dddd dddd)//====

Eval(Print(`
Following 2 examples show difference in how arguments are treated in 
processing mode and define mode.  Remember Eval is similar to defining
a temporary macro, then running it, then forgetting the macro. Eval()
is to evaluate the value of one expression, Eval{} is used to evaluate
a compound expression.`))

Firstly in processing mode :-
-----------------------------

ShowArgs("", aaaa, "bbbb", 123, 123.456, "20/09/1953")

Secondly in define mode :-
--------------------------

Eval(ShowArgs("", aaaa, "bbbb", 123, 123.456, "20/09/1953"))

Define AddArgs()        
/*
    Similar concept to ShowArgs, except that all the input arguments
    are summed, and the total value returned.
*/                          
{
    for (i = 0; i < argc; i += 1) {
        rv += argv[i];
    }
    return rv;
}

AddArgs(1,2,3,4,5,6,7,8,9,10,11,12) is the sum of the numbers from 1 to 12

